if (top.HlpSys === undefined) {
    top.HlpSys = new Object();
}

top.HlpSys.favorites = function() {
    var cookieWorker = new CookieWorker(top.document, "autodesk_online_help_favorites", 24000);
    var favoritesData = {
        urlString : "",
        titleString : ""
    };

    var favoritesList = new Array();
    var selectedFavoriteItem = 0;



    return {
        selectFavoriteItem: function(number) {
            selectedFavoriteItem = number;
        },

        removeSeceltedFavoriteItem: function() {

            if (selectedFavoriteItem < favoritesList.length) {
                favoritesList.splice(selectedFavoriteItem, 1);
                this.synchronizeFavoriteData();
            }
        },

        initalFavoritesLoad: function () {
            cookieWorker.load(favoritesData);
        },

        addToFavorites: function(doc)
        {
            var url = doc.URL;
            if (url.indexOf("?") != -1) {
                url = url.substring(0, url.indexOf("?"));
            }
            var title = doc.title;
            cookieWorker.load(favoritesData);
            if (favoritesData.urlString.indexOf(url) == -1) {
                if (favoritesData.urlString) favoritesData.urlString += ";" + url;
                else favoritesData.urlString = url;
                if (favoritesData.titleString) favoritesData.titleString += ";" + title;
                else favoritesData.titleString = title;
                cookieWorker.store(favoritesData);
                this.refreshFavoritesList();
            }
            this.refreshFavoritesPanel();
        },

        refreshFavoritesPanel: function() {
            if (navigator.appName == "Netscape")
            {
                top.left_tab.document.getElementById('iframeFavoritesFrame').contentDocument.location.reload();
            }
            else if (navigator.appName == "Microsoft Internet Explorer")
            {
                top.left_tab.document.frames("iframeFavoritesFrame").document.location.reload();
            }
            else alert("Unsupported browser !");


        },

        refreshFavoritesList: function()
        {
            cookieWorker.load(favoritesData);
            var urls = favoritesData.urlString.split(";");
            var titles = favoritesData.titleString.split(";");
            for (i = 0; i < urls.length; i++) {
                favoritesList[i] = new Array();
                favoritesList[i][0] = urls[i];
                favoritesList[i][1] = titles[i];
            }
        },

        synchronizeFavoriteData: function()
        {
            var url = "";
            var titles = "";
            for (i = 0; i < favoritesList.length; i++) {
                url += favoritesList[i][0];
                titles += favoritesList[i][1];
                if (i != (favoritesList.length - 1)) {
                    url += ";";
                    titles += ";";
                }
            }
            favoritesData.urlString = url;
            favoritesData.titleString = titles;
            cookieWorker.store(favoritesData);
            this.refreshFavoritesPanel();
        },

        loadFromFavorites: function()
        {
            if (navigator.appName == "Netscape")
            {
                document.getElementById('favoritesList').contentDocument.open();
                document.getElementById('favoritesList').contentDocument.write('<html><head><link rel="stylesheet" type="text/css" href="style/adsk.panels.css"><link rel="stylesheet" type="text/css" href="style/adsk.panels.custom.css"></head><body>');
                for (i = 0; i < favoritesList.length; i++) {
                    document.getElementById('favoritesList').contentDocument.write('<div ><a class="favoritesLink" target="content" onclick="top.HlpSys.favorites.selectFavoriteItem(' + i + ');" href="' + favoritesList[i][0] + '">' + favoritesList[i][1] + '</a></div>');
                }
                document.getElementById("favoritesList").contentDocument.write('</body></html>');
                document.getElementById('favoritesList').contentDocument.close();
            }
            else if (navigator.appName == "Microsoft Internet Explorer")
            {
                document.frames("favoritesList").document.open();
                document.frames("favoritesList").document.write('<html><head><link rel="stylesheet" type="text/css" href="style/adsk.panels.css"><link rel="stylesheet" type="text/css" href="style/adsk.panels.custom.css"></head><body>');
                for (i = 0; i < favoritesList.length; i++) {
                    var url = favoritesList[i][0];
                    url = unescape(url)
                    if (url.match(/^[\\\/][A-Z]:/g)) {
                        url = url.slice(1);
                    }
                    document.frames("favoritesList").document.write('<div><a class="favoritesLink" target="content"  onclick="top.HlpSys.favorites.selectFavoriteItem(' + i + ');" href="' + url + '">' + favoritesList[i][1] + '</a></div>');
                }
                document.frames("favoritesList").document.write('</body></html>');
                document.frames("favoritesList").document.close();
            }
            else alert("Unsupported browser !");
        }


    };
}();








// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEMzA
// SIG // r7j/TaZkZSwXLilAh5CgggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQoxRD
// SIG // xZ5X9J5C+LIGCq7UzDBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAGM+8iL9JqFf76+kerHil
// SIG // LBWc84l2cPhNnx13W+GwG/XUrSjtCwM9VgOjvuKGg3iP
// SIG // VnW/6H7xagK/K5rZ72wIJLpw6zZHL+4sHau5KwR7DkDJ
// SIG // yAfiG02P9glo5gfqLrVb6blPOfY/dH00MjKog6yHEG7Q
// SIG // eOPCmvdjDLWxS1/98e0=
// SIG // End signature block
